<?php
include_once(dirname(__FILE__) . "/connector/mysql.php");
include_once(dirname(__FILE__) . "/../domain/Pessoa.class.php");

class PessoaDAO {

    private $mysqli;

    private function connect() {
        $this->mysqli = new mysqli(MysqlConnector::$mysql_hostname, MysqlConnector::$mysql_username, MysqlConnector::$mysql_password, MysqlConnector::$mysql_db);
        if (mysqli_connect_errno()) {
            printf("Falha na conexção: %s\n", mysqli_connect_error());
            exit();
        }
    }

    private function close() {
        $this->mysqli->close();
    }

    public function persist(Pessoa $pessoa) {
        $this->connect();
        $stmt = $this->mysqli->prepare("INSERT INTO pessoa (cpf, nome) VALUES (?, ?)");
        $stmt->bind_param('ss', $cpf, $nome);
        $cpf = $pessoa->getCpf();
        $nome = $pessoa->getNome();
        $stmt->execute();
        $this->close();
        return $stmt->affected_rows;
    }

    public function remove(Pessoa $pessoa) {
        $this->connect();
        $stmt = $this->mysqli->prepare("DELETE FROM pessoa WHERE cpf = ?");
        $stmt->bind_param('s', $cpf);
        $cpf = $pessoa->getCpf();
        $stmt->execute();
        $this->close();
        return $stmt->affected_rows;
    }

    public function getPessoas() {
        $this->connect();
        $query = "SELECT cpf, nome FROM pessoa";
        if ($result = $this->mysqli->query($query)) {
            $i = 0;
            while ($row = $result->fetch_row()) {
                $pessoa = new Pessoa($row[0], $row[1]);
                $pessoas[$i++] = $pessoa;
            }
            $result->close();
        }
        $this->close();
        return $pessoas;
    }
}
?>
