using System;
using NUnit.Framework;

namespace NUnitExemplo1
{	
	[TestFixture]
	public class CalculadoraUnitTests
	{		
		private Calculadora calculadora;
		
		public CalculadoraUnitTests()
		{
		}
		
		[TestFixtureSetUp]
		public void Inicializar()
		{
			calculadora = new Calculadora();
		}
		
		[TestFixtureTearDown]
		public void Finalizar()
		{
			calculadora = null;
		}
		
		[Test]
		public void TestSoma()
		{
			int result = calculadora.Soma(2, 3);
			Assert.AreEqual(5, result);
		}
		
		[Test]
		public void TestSubtrai()
		{
			int result = calculadora.Subtrai(3, 2);
			Assert.AreEqual(1, result);

			result = calculadora.Subtrai(2, 3);
			Assert.AreEqual(-1,result);
		}

		[Test]
		public void TestMultiplica()
		{
			int result = calculadora.Multiplica(2, 3);
			Assert.AreEqual(6, result);
		}

		[Test, ExpectedException(typeof(DivideByZeroException))]
		public void TestDivide()
		{
			int result = calculadora.Divide(4, 2);
			Assert.AreEqual(2, result);

			result = calculadora.Divide(2, 0);
		}
	}
}
