using System;
using System.Collections.Generic;

namespace DbCmdNet
{
	public class Comando
	{
		private TipoDeComando pTipo;
		public TipoDeComando Tipo
		{
			get { return pTipo; }
			set { pTipo = value; }
		}
		private Dictionary<string,string> pParametros;
		public Dictionary<string,string> Parametros
		{
			get { return pParametros; }
			set { pParametros = value; }
		}
		public string[] IdentificacaoDosParametros
		{
			get
			{
				switch(Tipo)
				{
				    case TipoDeComando.Abrir:
						return new string[] { "servidor", "porta", "banco", "usuario", "senha" };
                    case TipoDeComando.ExportarParaXml:
                        return new string[] { "sql", "arquivo" };
					case TipoDeComando.Fechar:
						return new string[] { };
					case TipoDeComando.Consulta:
					case TipoDeComando.Comando:
					case TipoDeComando.Desconhecido:
						return new string[] {"comando" };
				    default:
					    throw new InvalidOperationException("Bug! Comando não previsto foi recebido.");
				}
			}
		}
		public static Comando CriarComando(string cmd)
		{
			string cmdTratado = cmd.ToLower().Trim();
            if (cmdTratado == "abrir")
                return new Comando(TipoDeComando.Abrir);
            else if (cmdTratado == "fechar")
                return new Comando(TipoDeComando.Fechar);
            else if (cmdTratado.StartsWith("select"))
                return new Comando(TipoDeComando.Consulta);
            else if (cmdTratado.StartsWith("insert")
                     ||
                     cmdTratado.StartsWith("update")
                     ||
                     cmdTratado.StartsWith("delete")
                     ||
                     cmdTratado.StartsWith("create"))
                return new Comando(TipoDeComando.Comando);
            else if (cmdTratado == "xml")
                return new Comando(TipoDeComando.ExportarParaXml);
            else
                return new Comando(TipoDeComando.Desconhecido);
		}
		private Comando(TipoDeComando tipo)
			: this(tipo, new Dictionary<string,string>())
		{
			
		}
		private Comando(TipoDeComando tipo, Dictionary<string,string> parametros)			
		{
			this.Tipo = tipo;
			this.Parametros = parametros;
		}
	}
}
