using System;
using System.Data;

namespace DbCmdNet
{
	class MainClass
	{
		public const char Prompt = '>';
		public const char ParametroPrompt = ':';
		public const char ResultadoPrompt = '=';
		public const char ErroPrompt = 'E';
		public static Comando RetornarComando()
		{			
			Console.Write(Prompt + " ");
			
			Comando c;
            string linha = Console.ReadLine();
			c = Comando.CriarComando(linha);
            if (c.IdentificacaoDosParametros.Length > 1)
                foreach (string p in c.IdentificacaoDosParametros)
                {
                    Console.Write(p + ParametroPrompt + " ");
                    c.Parametros[p] = Console.ReadLine();
                }
            else if (c.IdentificacaoDosParametros.Length == 1)
                c.Parametros[c.IdentificacaoDosParametros[0]] = linha;
			
			return c;
		}					
		public static void ProcessarComandos()
		{
			Processador processador = new Processador();
			Comando c = null;
			do
			{				
				try
				{
					c = RetornarComando();
					DataTable r = processador.Processar(c);
					if (r.Rows.Count > 0)
					{
						foreach(DataRow row in r.Rows)
						{
							foreach(DataColumn col in r.Columns)
							{
								Console.WriteLine(ResultadoPrompt + " " + col.ColumnName + ": " + row[col].ToString());
							}
							Console.WriteLine(ResultadoPrompt + " " + new string('-',10));
						}
					}
				}
				catch(Exception ex)
				{
					string[] erromsg = (ex.Source + ": " + ex.Message + "\nStack: " + ex.StackTrace).Split(new char[] { '\n' } );
					foreach(string s in erromsg)
						Console.WriteLine(ErroPrompt + " " + s); 
				}
			} while (c!=null && c.Tipo != TipoDeComando.Fechar);			
		}
		public static void Main(string[] args)
		{
			ProcessarComandos();
		}
	}
}