using System;
using System.Data;
using MySql.Data.MySqlClient;

namespace DbCmdNet
{
	public class Processador
	{
		private System.Data.IDbConnection pConexao;
		protected System.Data.IDbConnection Conexao
		{
			get
			{
				return pConexao;
			}
			set
			{
				pConexao = value;
			}
		}
		private System.Data.IDbCommand pComando;
		protected System.Data.IDbCommand Comando
		{
			get				
			{
				return pComando;
			}
			set
			{
				pComando = value;
			}
		}
		private DataTable Abrir(Comando c)
		{			
			string stringDeConexao = 
				String.Format("server={0};port={1};database={2};user id={3};password={4};pooling=false;persist security info=true;",
				new string[] { c.Parametros["servidor"],
					           c.Parametros["porta"],
				               c.Parametros["banco"],
				               c.Parametros["usuario"],
					           c.Parametros["senha"] } );					
			Conexao = new MySqlConnection(stringDeConexao);			
			Conexao.Open();	
			return new DataTable(c.Tipo.ToString());
		}
        private DataTable ExportarParaXml(Comando c)
        {
            Comando consulta = DbCmdNet.Comando.CriarComando(c.Parametros["sql"]);
            consulta.Parametros["comando"] = c.Parametros["sql"];
            ExecutarConsulta(consulta).WriteXml(c.Parametros["arquivo"]);

            return new DataTable(c.Tipo.ToString());
        }
		private DataTable Fechar(Comando c)
		{
			if (Conexao != null 
			    &&
			    Conexao.State != ConnectionState.Closed)
				Conexao.Close();
			return new DataTable(c.Tipo.ToString());
		}
		private DataTable ExecutarComandoSql(Comando c)
		{			
			if (Comando == null)
				Comando = new MySqlCommand();
            Comando.Connection = Conexao;
			Comando.CommandText = c.Parametros["comando"];

            DataTable r = new DataTable(c.Tipo.ToString());
            r.Columns.Add("Tuplas afetadas");			
			r.Rows.Add(new object[] { Comando.ExecuteNonQuery() });

			return r;
		}
		private DataTable ExecutarConsulta(Comando c)
		{
			DataTable r = new DataTable(c.Tipo.ToString());
			
			if (Comando == null)
				Comando = new MySqlCommand();
            Comando.Connection = Conexao;
			Comando.CommandText = c.Parametros["comando"];
			
			MySqlDataAdapter adaptador = new MySqlDataAdapter((MySqlCommand)this.Comando);
			adaptador.Fill(r);
			return r;
		}
		public DataTable Processar(Comando c)
		{
            if (c.Tipo == TipoDeComando.Abrir)
                return Abrir(c);
            else if (c.Tipo == TipoDeComando.Fechar)
                return Fechar(c);
            else if (c.Tipo == TipoDeComando.Comando)
                return ExecutarComandoSql(c);
            else if (c.Tipo == TipoDeComando.Consulta)
                return ExecutarConsulta(c);
            else if (c.Tipo == TipoDeComando.ExportarParaXml)
                return ExportarParaXml(c);
            else
                return ExecutarComandoSql(c);
		}
		public Processador()
		{
		}
	}
}
